/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bvalid.locator;

import java.io.InputStream;
import net.sf.bvalid.ValidatorException;
import net.sf.bvalid.catalog.SchemaCatalog;
import net.sf.bvalid.locator.SchemaLocator;
import org.apache.log4j.Logger;

public class CachingSchemaLocator
implements SchemaLocator {
    private static Logger _LOG = Logger.getLogger((String)CachingSchemaLocator.class.getName());
    private SchemaCatalog _candidateCatalog;
    private SchemaCatalog _cacheCatalog;
    private SchemaLocator _locator;

    public CachingSchemaLocator(SchemaCatalog candidateCatalog, SchemaCatalog cacheCatalog, SchemaLocator locator) {
        this._candidateCatalog = candidateCatalog;
        this._cacheCatalog = cacheCatalog;
        this._locator = locator;
    }

    public synchronized InputStream get(String uri, boolean required) throws ValidatorException {
        InputStream in = this._cacheCatalog.get(uri);
        if (in != null) {
            _LOG.info((Object)("Got from cache: " + uri));
            return in;
        }
        in = this._locator.get(uri, required);
        if (in == null) {
            return null;
        }
        _LOG.debug((Object)("Added to candidate catalog: " + uri));
        this._candidateCatalog.put(uri, in);
        return this._candidateCatalog.get(uri);
    }

    public synchronized void successfullyUsed(String uri) throws ValidatorException {
        if (!this._cacheCatalog.contains(uri) && this._candidateCatalog.contains(uri)) {
            InputStream in = this._candidateCatalog.get(uri);
            this._cacheCatalog.put(uri, in);
            this._candidateCatalog.remove(uri);
            _LOG.debug((Object)("Cached because successfully used: " + uri));
        }
    }
}

