/*
 * Decompiled with CFR 0.152.
 */
package org.jrdf.graph.mem;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jrdf.graph.AbstractTripleFactoryUnitTest;
import org.jrdf.graph.Alternative;
import org.jrdf.graph.Bag;
import org.jrdf.graph.Collection;
import org.jrdf.graph.Graph;
import org.jrdf.graph.GraphElementFactoryException;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.Sequence;
import org.jrdf.graph.TripleFactoryException;
import org.jrdf.graph.mem.AlternativeImpl;
import org.jrdf.graph.mem.BagImpl;
import org.jrdf.graph.mem.CollectionImpl;
import org.jrdf.graph.mem.GraphImpl;
import org.jrdf.graph.mem.SequenceImpl;
import org.jrdf.vocabulary.RDF;

public class TripleFactoryUnitTest
extends AbstractTripleFactoryUnitTest {
    public TripleFactoryUnitTest(String string) {
        super(string);
    }

    public Graph newGraph() throws Exception {
        return new GraphImpl();
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TripleFactoryUnitTest("testReification"));
        testSuite.addTest((Test)new TripleFactoryUnitTest("testCollections"));
        testSuite.addTest((Test)new TripleFactoryUnitTest("testAlternative"));
        testSuite.addTest((Test)new TripleFactoryUnitTest("testBag"));
        testSuite.addTest((Test)new TripleFactoryUnitTest("testSequence"));
        return testSuite;
    }

    public static void main(String[] stringArray) throws Exception {
        TestRunner.run((Test)TripleFactoryUnitTest.suite());
    }

    public PredicateNode getReifySubject() throws TripleFactoryException {
        try {
            return this.elementFactory.createResource(RDF.SUBJECT);
        }
        catch (GraphElementFactoryException graphElementFactoryException) {
            throw new TripleFactoryException(graphElementFactoryException);
        }
    }

    public PredicateNode getReifyPredicate() throws TripleFactoryException {
        try {
            return this.elementFactory.createResource(RDF.PREDICATE);
        }
        catch (GraphElementFactoryException graphElementFactoryException) {
            throw new TripleFactoryException(graphElementFactoryException);
        }
    }

    public PredicateNode getReifyObject() throws TripleFactoryException {
        try {
            return this.elementFactory.createResource(RDF.OBJECT);
        }
        catch (GraphElementFactoryException graphElementFactoryException) {
            throw new TripleFactoryException(graphElementFactoryException);
        }
    }

    public PredicateNode getRdfType() throws TripleFactoryException {
        try {
            return this.elementFactory.createResource(RDF.TYPE);
        }
        catch (GraphElementFactoryException graphElementFactoryException) {
            throw new TripleFactoryException(graphElementFactoryException);
        }
    }

    public ObjectNode getRdfStatement() throws TripleFactoryException {
        try {
            return this.elementFactory.createResource(RDF.STATEMENT);
        }
        catch (GraphElementFactoryException graphElementFactoryException) {
            throw new TripleFactoryException(graphElementFactoryException);
        }
    }

    public Collection createCollection(ObjectNode[] objectNodeArray) {
        CollectionImpl collectionImpl = new CollectionImpl();
        for (int i = 0; i < objectNodeArray.length; ++i) {
            collectionImpl.add(objectNodeArray[i]);
        }
        return collectionImpl;
    }

    public Alternative createAlternative(ObjectNode[] objectNodeArray) {
        AlternativeImpl alternativeImpl = new AlternativeImpl();
        for (int i = 0; i < objectNodeArray.length; ++i) {
            alternativeImpl.add(objectNodeArray[i]);
        }
        return alternativeImpl;
    }

    public Bag createBag(ObjectNode[] objectNodeArray) {
        BagImpl bagImpl = new BagImpl();
        for (int i = 0; i < objectNodeArray.length; ++i) {
            bagImpl.add(objectNodeArray[i]);
        }
        return bagImpl;
    }

    public Sequence createSequence(ObjectNode[] objectNodeArray) {
        SequenceImpl sequenceImpl = new SequenceImpl();
        for (int i = 0; i < objectNodeArray.length; ++i) {
            sequenceImpl.add(objectNodeArray[i]);
        }
        return sequenceImpl;
    }
}

