/*
 * Decompiled with CFR 0.152.
 */
package org.nsdl.mptstore.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.nsdl.mptstore.core.DDLGenerator;
import org.nsdl.mptstore.core.TableManager;
import org.nsdl.mptstore.rdf.PredicateNode;
import org.nsdl.mptstore.util.NTriplesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicTableManager
implements TableManager {
    private static final Logger LOG = Logger.getLogger((String)BasicTableManager.class.getName());
    private DataSource _dataSource;
    private DDLGenerator _ddlGenerator;
    private String _mapTable;
    private String _soTablePrefix;
    private Map<PredicateNode, String> _map;
    private Map<String, PredicateNode> _reverseMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicTableManager(DataSource dataSource, DDLGenerator ddlGenerator, String mapTable, String soTablePrefix) throws SQLException {
        this._dataSource = dataSource;
        this._ddlGenerator = ddlGenerator;
        this._mapTable = mapTable;
        this._soTablePrefix = soTablePrefix;
        Connection conn = dataSource.getConnection();
        try {
            if (!this.mapTableExists(conn)) {
                LOG.info((Object)"Creating map table");
                this.executeDDL(conn, this._ddlGenerator.getCreateMapTableDDL(this._mapTable).iterator());
            }
            this.loadMapTable(conn);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"unable to close/release connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOrMapTableFor(PredicateNode predicate) throws SQLException {
        String table = this.getTableFor(predicate);
        if (table != null) {
            return table;
        }
        Connection conn = this._dataSource.getConnection();
        try {
            String string = this.mapTableFor(predicate, conn);
            return string;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"unable to close/release connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTableFor(PredicateNode predicate) {
        Map<PredicateNode, String> map = this._map;
        synchronized (map) {
            return this._map.get(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PredicateNode getPredicateFor(String table) {
        Map<PredicateNode, String> map = this._map;
        synchronized (map) {
            return this._reverseMap.get(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getTables() {
        Map<PredicateNode, String> map = this._map;
        synchronized (map) {
            return new HashSet<String>(this._reverseMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PredicateNode> getPredicates() {
        Map<PredicateNode, String> map = this._map;
        synchronized (map) {
            return new HashSet<PredicateNode>(this._map.keySet());
        }
    }

    @Override
    public int dropEmptyPredicateTables() throws SQLException {
        LOG.info((Object)"Dropping empty predicate tables");
        return this.dropPredicateTables(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mapTableExists(Connection conn) throws SQLException {
        boolean exists;
        Statement st;
        block35: {
            block34: {
                ResultSet results = conn.getMetaData().getTables(null, null, this._mapTable, null);
                try {
                    if (results.next()) {
                        LOG.info((Object)"Found pre-existing map table");
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    try {
                        results.close();
                    }
                    catch (SQLException e) {
                        LOG.warn((Object)"unable to close result set", (Throwable)e);
                    }
                }
                st = conn.createStatement();
                exists = false;
                try {
                    results = null;
                    results = st.executeQuery("SELECT COUNT(*) FROM " + this._mapTable);
                    exists = results.next();
                }
                catch (SQLException e) {
                    boolean e2 = false;
                    try {
                        st.close();
                    }
                    catch (SQLException e3) {
                        LOG.warn((Object)"unable to close statement", (Throwable)e3);
                    }
                    return e2;
                }
                finally {
                    try {
                        if (results != null) {
                            results.close();
                        }
                    }
                    catch (SQLException e) {
                        LOG.warn((Object)"unable to close result set", (Throwable)e);
                    }
                }
                if (!exists) break block34;
                LOG.info((Object)"Found pre-existing map table");
                break block35;
            }
            LOG.info((Object)"Map table does not yet exist");
        }
        boolean bl = exists;
        return bl;
        finally {
            try {
                st.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"unable to close statement", (Throwable)e);
            }
        }
    }

    private void loadMapTable(Connection conn) throws SQLException {
        LOG.info((Object)"Loading map table");
        this._map = new HashMap<PredicateNode, String>();
        this._reverseMap = new HashMap<String, PredicateNode>();
        Statement st = conn.createStatement();
        ResultSet results = null;
        String pString = null;
        try {
            results = st.executeQuery("SELECT pKey, p FROM " + this._mapTable);
            while (results.next()) {
                String table = this._soTablePrefix + results.getInt(1);
                pString = results.getString(2);
                PredicateNode predicate = NTriplesUtil.parsePredicate(pString);
                this._map.put(predicate, table);
                this._reverseMap.put(table, predicate);
            }
        }
        catch (ParseException e) {
            throw new SQLException("Unable to parse predicate (" + pString + ") from map table. " + e.getMessage());
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"unable to close result set", (Throwable)e);
                }
            }
            try {
                st.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"unable to close statement", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String mapTableFor(PredicateNode predicate, Connection conn) throws SQLException {
        String table = this.getTableFor(predicate);
        if (table != null) {
            return table;
        }
        LOG.info((Object)("Mapping new table for predicate: " + predicate.toString()));
        int id = this.addPredicateToMapTable(predicate, conn);
        try {
            table = this._soTablePrefix + id;
            this.executeDDL(conn, this._ddlGenerator.getCreateSOTableDDL(table).iterator());
        }
        catch (SQLException e) {
            try {
                this.deletePredicateFromMapTable(predicate, conn);
            }
            catch (SQLException e2) {
                LOG.warn((Object)"unable to clean up entry from map table after failure to create predicate table", (Throwable)e2);
            }
            throw e;
        }
        Map<PredicateNode, String> map = this._map;
        synchronized (map) {
            this._map.put(predicate, table);
            this._reverseMap.put(table, predicate);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addPredicateToMapTable(PredicateNode predicate, Connection conn) throws SQLException {
        String pString = predicate.toString();
        PreparedStatement ps = conn.prepareStatement("INSERT INTO " + this._mapTable + " (p) VALUES (?)");
        try {
            ps.setString(1, pString);
            ps.execute();
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"unable to close statement", (Throwable)e);
            }
        }
        ps = conn.prepareStatement("SELECT pKey from " + this._mapTable + " WHERE p = ?");
        try {
            int n;
            ps.setString(1, pString);
            ResultSet rs = ps.executeQuery();
            try {
                rs.next();
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"unable to close result set", (Throwable)e);
                }
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"unable to close result set", (Throwable)e);
            }
            return n;
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"unable to close statement", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePredicateFromMapTable(PredicateNode predicate, Connection conn) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("DELETE FROM " + this._mapTable + " WHERE p = ?");
        try {
            ps.setString(1, predicate.toString());
            ps.execute();
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"unable to close statement", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDDL(Connection conn, Iterator<String> ddlIter) throws SQLException {
        Statement st = conn.createStatement();
        try {
            while (ddlIter.hasNext()) {
                String ddl = ddlIter.next();
                LOG.info((Object)("Executing DDL: " + ddl));
                st.executeUpdate(ddl);
            }
        }
        finally {
            try {
                st.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"unable to close statement", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int dropPredicateTables(boolean all) throws SQLException {
        int dropCount = 0;
        Connection conn = this._dataSource.getConnection();
        try {
            for (String table : this.getTables()) {
                if (!all && !this.isPredicateTableEmpty(table, conn)) continue;
                PredicateNode predicate = this.getPredicateFor(table);
                this.unmapPredicate(predicate, table, conn);
                ++dropCount;
            }
            int n = dropCount;
            return n;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"unable to close/release connection", (Throwable)e);
            }
        }
    }

    @Override
    public int dropAllPredicateTables() throws SQLException {
        LOG.info((Object)"Dropping all predicate tables");
        return this.dropPredicateTables(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPredicateTableEmpty(String table, Connection conn) throws SQLException {
        Statement st = conn.createStatement();
        try {
            boolean bl;
            ResultSet results = st.executeQuery("SELECT MAX(s) FROM " + table);
            try {
                bl = !results.next();
            }
            catch (Throwable throwable) {
                try {
                    results.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"unable to close result set", (Throwable)e);
                }
                throw throwable;
            }
            try {
                results.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"unable to close result set", (Throwable)e);
            }
            return bl;
        }
        finally {
            try {
                st.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"unable to close statement", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unmapPredicate(PredicateNode predicate, String table, Connection conn) throws SQLException {
        String pString = predicate.toString();
        LOG.info((Object)("Unmapping " + pString + " and dropping associated table: " + table));
        this._map.remove(predicate);
        this._reverseMap.remove(table);
        PreparedStatement ps = conn.prepareStatement("DELETE FROM " + this._mapTable + " WHERE p = ?");
        try {
            ps.setString(1, pString);
            ps.execute();
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"unable to close statement", (Throwable)e);
            }
        }
        this.executeDDL(conn, this._ddlGenerator.getDropSOTableDDL(table).iterator());
    }
}

