/*
 * Decompiled with CFR 0.152.
 */
package org.nsdl.mptstore.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.nsdl.mptstore.core.DatabaseAdaptor;
import org.nsdl.mptstore.core.ModificationException;
import org.nsdl.mptstore.core.TableManager;
import org.nsdl.mptstore.query.QueryException;
import org.nsdl.mptstore.query.QueryResults;
import org.nsdl.mptstore.query.SQLUnionQueryResults;
import org.nsdl.mptstore.query.lang.QueryCompiler;
import org.nsdl.mptstore.query.lang.QueryLanguage;
import org.nsdl.mptstore.query.lang.spo.SPOQueryCompiler;
import org.nsdl.mptstore.query.provider.SQLProvider;
import org.nsdl.mptstore.rdf.PredicateNode;
import org.nsdl.mptstore.rdf.Triple;
import org.nsdl.mptstore.util.DBUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDatabaseAdaptor
implements DatabaseAdaptor {
    private static final Logger LOG = Logger.getLogger((String)GenericDatabaseAdaptor.class.getName());
    private TableManager _tableManager;
    private Map<QueryLanguage, QueryCompiler> _compilerMap;

    public GenericDatabaseAdaptor(TableManager tableManager, boolean backslashIsEscape) {
        this._tableManager = tableManager;
        this._compilerMap = new HashMap<QueryLanguage, QueryCompiler>();
        this._compilerMap.put(QueryLanguage.SPO, new SPOQueryCompiler(this._tableManager, backslashIsEscape));
    }

    public GenericDatabaseAdaptor(TableManager tableManager, Map<QueryLanguage, QueryCompiler> compilerMap) {
        this._tableManager = tableManager;
        this._compilerMap = compilerMap;
    }

    @Override
    public void addTriples(Connection conn, Iterator<Triple> triples) throws ModificationException {
        LOG.debug((Object)"Started adding triples to database");
        this.updateTriples(conn, triples, false);
        LOG.debug((Object)"Finished adding triples to database");
    }

    @Override
    public void deleteTriples(Connection conn, Iterator<Triple> triples) throws ModificationException {
        LOG.debug((Object)"Started deleting triples from database");
        this.updateTriples(conn, triples, true);
        LOG.debug((Object)"Finished deleting triples from database");
    }

    private void updateTriples(Connection conn, Iterator<Triple> triples, boolean delete) throws ModificationException {
        HashMap<PredicateNode, PreparedStatement> statements = new HashMap<PredicateNode, PreparedStatement>();
        try {
            while (triples.hasNext()) {
                PredicateNode predicate;
                PreparedStatement statement;
                Triple triple = triples.next();
                if (LOG.isDebugEnabled()) {
                    String prefix = delete ? "Deleting " : "Adding ";
                    LOG.debug((Object)(prefix + triple.toString()));
                }
                if ((statement = (PreparedStatement)statements.get(predicate = triple.getPredicate())) == null) {
                    String table = this._tableManager.getOrMapTableFor(predicate);
                    String sql = delete ? "DELETE FROM " + table + " WHERE s = ? AND o = ?" : "INSERT INTO " + table + " (s, o) VALUES (?, ?)";
                    statement = conn.prepareStatement(sql);
                    statements.put(predicate, statement);
                }
                statement.setString(1, triple.getSubject().toString());
                statement.setString(2, triple.getObject().toString());
                statement.execute();
            }
        }
        catch (SQLException e) {
            throw new ModificationException("Database update failed", e);
        }
        finally {
            for (PreparedStatement statement : statements.values()) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"unable to close statement", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void deleteAllTriples(Connection conn) throws ModificationException {
        try {
            this._tableManager.dropAllPredicateTables();
        }
        catch (SQLException e) {
            throw new ModificationException("Failed to delete all triples", e);
        }
    }

    @Override
    public QueryResults query(Connection connection, QueryLanguage language, int fetchSize, boolean autoReleaseConnection, String query) throws QueryException {
        SQLUnionQueryResults results = null;
        try {
            QueryCompiler compiler = this._compilerMap.get(language);
            if (compiler != null) {
                SQLProvider provider = compiler.compile(query);
                SQLUnionQueryResults sQLUnionQueryResults = results = new SQLUnionQueryResults(connection, provider, fetchSize, autoReleaseConnection);
                return sQLUnionQueryResults;
            }
            throw new QueryException("Query language not supported: " + language.getName());
        }
        finally {
            if (results == null && autoReleaseConnection) {
                DBUtil.release(connection);
            }
        }
    }
}

