/*
 * Decompiled with CFR 0.152.
 */
package org.nsdl.mptstore.impl.derby;

import java.util.ArrayList;
import java.util.List;
import org.nsdl.mptstore.core.AbstractDDLGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerbyDDLGenerator
extends AbstractDDLGenerator {
    private static final int DEFAULT_VARCHAR_LENGTH = 512;
    private final int _varcharLength;

    public DerbyDDLGenerator() {
        this._varcharLength = 512;
    }

    public DerbyDDLGenerator(int varcharLength) {
        this._varcharLength = varcharLength;
    }

    @Override
    public List<String> getCreateMapTableDDL(String table) {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("CREATE TABLE " + table + " (\n" + "  pKey INT NOT NULL GENERATED ALWAYS AS IDENTITY,\n" + "  p VARCHAR(" + this._varcharLength + ") NOT NULL\n" + ")");
        cmds.add("CREATE INDEX " + table + "_pKey " + " on " + table + " (pKey)");
        cmds.add("CREATE INDEX " + table + "_p " + " on " + table + " (p)");
        return cmds;
    }

    @Override
    public List<String> getCreateSOTableDDL(String table) {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("CREATE TABLE " + table + " (\n" + "  s VARCHAR(" + this._varcharLength + ") NOT NULL,\n" + "  o VARCHAR(" + this._varcharLength + ") NOT NULL\n" + ")");
        cmds.add("CREATE INDEX " + table + "_s " + " on " + table + " (s)");
        cmds.add("CREATE INDEX " + table + "_o " + " on " + table + " (o)");
        return cmds;
    }
}

