/*
 * Decompiled with CFR 0.152.
 */
package org.nsdl.mptstore.query.component;

import org.nsdl.mptstore.query.component.NodePattern;
import org.nsdl.mptstore.rdf.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicNodePattern<T extends Node>
implements NodePattern<T> {
    private final T nodeValue;
    private final boolean isVariable;
    private final String varName;

    public BasicNodePattern(T node) {
        this.nodeValue = node;
        this.isVariable = false;
        this.varName = null;
    }

    public BasicNodePattern(String variable) {
        this.nodeValue = null;
        this.isVariable = true;
        this.varName = variable;
    }

    @Override
    public T getNode() {
        return this.nodeValue;
    }

    @Override
    public String getVarName() {
        return this.varName;
    }

    @Override
    public boolean isVariable() {
        return this.isVariable;
    }

    public boolean equals(Object p) {
        if (!(p instanceof NodePattern)) {
            return false;
        }
        NodePattern comparison = (NodePattern)p;
        if (this.isVariable() && comparison.isVariable()) {
            if (this.getVarName() == null || comparison.getVarName() == null) {
                return false;
            }
            return this.getVarName().equals(comparison.getVarName());
        }
        if (!this.isVariable() && !comparison.isVariable()) {
            if (this.getNode() == null || comparison.getNode() == null) {
                return false;
            }
            try {
                return this.getNode().getValue().equals(comparison.getNode().getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.isVariable) {
            return this.varName.hashCode();
        }
        return this.nodeValue.hashCode();
    }

    public String toString() {
        if (this.isVariable) {
            return this.varName;
        }
        return this.nodeValue.toString();
    }
}

