/*
 * Decompiled with CFR 0.152.
 */
package org.nsdl.mptstore.rdf;

import java.text.ParseException;
import org.nsdl.mptstore.rdf.ObjectNode;
import org.nsdl.mptstore.rdf.URIReference;
import org.nsdl.mptstore.util.NTriplesUtil;

public class Literal
implements ObjectNode {
    private String _value;
    private String _language;
    private URIReference _datatype;

    public Literal(String value) {
        this._value = value;
    }

    public Literal(String value, String language) throws ParseException {
        this._value = value;
        if (language != null) {
            NTriplesUtil.validateLanguage(language);
            this._language = language.toLowerCase();
        }
    }

    public Literal(String value, URIReference datatype) {
        this._value = value;
        this._datatype = datatype;
    }

    public String getLanguage() {
        return this._language;
    }

    public URIReference getDatatype() {
        return this._datatype;
    }

    public String getValue() {
        return this._value;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append('\"');
        out.append(NTriplesUtil.escapeLiteralValue(this._value));
        out.append('\"');
        if (this._language != null) {
            out.append("@" + this._language);
        } else if (this._datatype != null) {
            out.append("^^" + this._datatype.toString());
        }
        return out.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Literal) {
            Literal lit = (Literal)obj;
            if (this._language != null) {
                return this._language.equals(lit.getLanguage()) && this._value.equals(lit.getValue());
            }
            if (this._datatype != null) {
                return this._datatype.equals(lit.getDatatype()) && this._value.equals(lit.getValue());
            }
            return lit.getLanguage() == null && lit.getDatatype() == null && this._value.equals(lit.getValue());
        }
        return false;
    }

    public int hashCode() {
        return this._value.hashCode();
    }
}

