/*
 * Decompiled with CFR 0.152.
 */
package proai.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import org.apache.log4j.Logger;
import proai.CloseableIterator;
import proai.cache.CachedContentAggregate;
import proai.error.BadResumptionTokenException;
import proai.error.ServerException;
import proai.service.ListProvider;
import proai.service.ResponseData;
import proai.service.ResponseDataImpl;
import proai.service.Session;
import proai.service.SessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheSession<T>
extends Thread
implements Session {
    private static final Logger _LOG = Logger.getLogger((String)CacheSession.class.getName());
    private SessionManager _manager;
    private File _baseDir;
    private int _secondsBetweenRequests;
    private ListProvider<T> _provider;
    private String _sessionKey;
    private int _threadWorkingPart;
    private int _lastGeneratedPart;
    private int _lastSentPart;
    private long _expirationTime;
    private ServerException _exception;
    private boolean _threadNeedsToFinish;
    private boolean _threadWorking;

    public CacheSession(SessionManager manager, File baseDir, int secondsBetweenRequests, ListProvider<T> provider) {
        this._manager = manager;
        this._baseDir = baseDir;
        this._secondsBetweenRequests = secondsBetweenRequests;
        this._provider = provider;
        String s = "" + this.hashCode();
        this._sessionKey = s.startsWith("-") ? "Z" + s.substring(1) : "X" + s;
        this._threadWorkingPart = 0;
        this._lastGeneratedPart = -1;
        this._lastSentPart = -1;
        this._threadWorking = true;
        this.setName("Session-" + this._sessionKey + "-Retriever");
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        _LOG.info((Object)(this._sessionKey + " retrieval thread started"));
        int incompleteListSize = this._provider.getIncompleteListSize();
        CloseableIterator<String[]> iter = null;
        PrintWriter out = null;
        try {
            iter = this._provider.getPathList();
            this._manager.addSession(this._sessionKey, this);
            File sessionDir = new File(this._baseDir, this._sessionKey);
            sessionDir.mkdirs();
            int cursor = 0;
            while (iter.hasNext() && !this._threadNeedsToFinish) {
                File listFile = new File(sessionDir, this._threadWorkingPart + ".txt");
                out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(listFile)));
                for (int i = 0; i < incompleteListSize && iter.hasNext(); ++i) {
                    String[] pathAndDate = iter.next();
                    out.print(pathAndDate[0]);
                    if (pathAndDate.length > 1) {
                        out.print(" " + pathAndDate[1]);
                    }
                    out.println();
                }
                if (iter.hasNext()) {
                    int nextPartNum = this._threadWorkingPart + 1;
                    String token = this._sessionKey + "/" + nextPartNum;
                    out.println("end " + token + " " + cursor);
                    cursor += incompleteListSize;
                } else if (cursor > 0) {
                    out.println("end " + cursor);
                } else {
                    out.println("end");
                }
                out.close();
                ++this._lastGeneratedPart;
                _LOG.debug((Object)("Successfully created file " + listFile.getPath()));
                if (!iter.hasNext()) continue;
                ++this._threadWorkingPart;
            }
        }
        catch (ServerException e) {
            this._exception = e;
        }
        catch (Throwable th) {
            this._exception = new ServerException("Unexpected error in session thread", th);
        }
        finally {
            if (iter != null) {
                try {
                    iter.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
            this._threadWorking = false;
            _LOG.info((Object)(this._sessionKey + " retrieval thread finished"));
        }
    }

    @Override
    public boolean hasExpired() {
        if (this._exception != null) {
            return true;
        }
        return this._lastGeneratedPart >= 0 && this._lastSentPart > -1 && this._expirationTime < System.currentTimeMillis();
    }

    @Override
    public void clean() {
        this._threadNeedsToFinish = true;
        while (this._threadWorking) {
            try {
                Thread.sleep(250L);
            }
            catch (Exception e) {}
        }
        File sessionDir = new File(this._baseDir, this._sessionKey);
        if (sessionDir.exists()) {
            File[] files = sessionDir.listFiles();
            _LOG.debug((Object)("Deleting session " + this._sessionKey + " directory and all " + files.length + " files within"));
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
            sessionDir.delete();
        }
    }

    @Override
    public ResponseData getResponseData(int partNum) throws ServerException, BadResumptionTokenException {
        if (this._exception != null) {
            throw this._exception;
        }
        _LOG.debug((Object)("Entered getResponseData(" + partNum + ")"));
        int nextPart = this._lastSentPart + 1;
        if (partNum == this._lastSentPart || partNum == nextPart) {
            while (this._threadWorking && this._lastGeneratedPart < partNum) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {}
            }
            if (this._exception != null) {
                throw this._exception;
            }
            File listFile = new File(this._baseDir, this._sessionKey + "/" + partNum + ".txt");
            if (!listFile.exists()) {
                StringBuffer message = new StringBuffer();
                message.append("the indicated part does not exist because ");
                message.append(listFile.getPath());
                message.append(" doesn't exist");
                File sessionDir = new File(this._baseDir, this._sessionKey);
                if (sessionDir.exists()) {
                    String[] names = sessionDir.list();
                    if (names.length == 0) {
                        message.append(".  In fact, the session directory is empty!  Has it expired unexpectedly?");
                    } else {
                        message.append(".  Only the following " + names.length + " files currently exist in the session" + " directory: ");
                        for (int i = 0; i < names.length; ++i) {
                            if (i > 0) {
                                message.append(", ");
                            }
                            message.append(names[i]);
                        }
                    }
                } else {
                    message.append(".  In fact, the session directory doesn't even exist.  Has it expired unexpectedly?");
                }
                _LOG.warn((Object)message.toString());
                throw new BadResumptionTokenException("the indicated part does not exist");
            }
            String token = this.getResumptionToken(partNum + 1);
            ResponseDataImpl response = new ResponseDataImpl(new CachedContentAggregate(listFile, this._provider.getVerb(), this._provider.getRecordCache()), token);
            if (partNum > 0) {
                int previousPart = partNum - 1;
                File toDelete = new File(this._baseDir, this._sessionKey + "/" + previousPart + ".txt");
                _LOG.debug((Object)("Deleting previous part: " + toDelete.getPath()));
                toDelete.delete();
            }
            this._lastSentPart = partNum;
            this._expirationTime = new Date().getTime() + (long)(1000 * this._secondsBetweenRequests);
            _LOG.info((Object)(this._sessionKey + " returning part " + partNum));
            return response;
        }
        throw new BadResumptionTokenException("the indicated part either doesn't exist yet or has expired");
    }

    private String getResumptionToken(int partNum) {
        if (this._threadWorking) {
            if (this._threadWorkingPart >= partNum) {
                return this._sessionKey + "/" + partNum;
            }
            return null;
        }
        if (partNum <= this._lastGeneratedPart) {
            return this._sessionKey + "/" + partNum;
        }
        return null;
    }

    public void finalize() {
        this.clean();
    }
}

