/*
 * Decompiled with CFR 0.152.
 */
package proai.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import proai.error.BadArgumentException;
import proai.error.BadVerbException;
import proai.error.ProtocolException;
import proai.error.ServerException;
import proai.service.Responder;
import proai.service.ResponseData;
import proai.util.StreamUtil;

public class ProviderServlet
extends HttpServlet {
    static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)ProviderServlet.class.getName());
    private static final String _XMLSTART = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<OAI-PMH xmlns=\"http://www.openarchives.org/OAI/2.0/\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://www.openarchives.org/OAI/2.0/\n                             http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd\">\n  <responseDate>";
    private Responder m_responder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        if (logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Started servicing request ( ");
            Map map = request.getParameterMap();
            for (String parmName : map.keySet()) {
                String[] parmVals = (String[])map.get(parmName);
                buf.append(parmName + "=" + parmVals[0] + " ");
            }
            buf.append(") from " + request.getRemoteAddr());
            logger.debug((Object)buf.toString());
        }
        String url = null;
        String verb = null;
        String identifier = null;
        String from = null;
        String until = null;
        String metadataPrefix = null;
        String set = null;
        String resumptionToken = null;
        try {
            url = request.getRequestURL().toString();
            verb = request.getParameter("verb");
            if (verb == null) {
                throw new BadVerbException("request did not specify a verb");
            }
            identifier = request.getParameter("identifier");
            from = request.getParameter("from");
            until = request.getParameter("until");
            metadataPrefix = request.getParameter("metadataPrefix");
            set = request.getParameter("set");
            resumptionToken = request.getParameter("resumptionToken");
            Set argKeys = request.getParameterMap().keySet();
            int argCount = argKeys.size() - 1;
            for (String n : argKeys) {
                if (n.equals("verb") || n.equals("identifier") || n.equals("from") || n.equals("until") || n.equals("metadataPrefix") || n.equals("set") || n.equals("resumptionToken")) continue;
                throw new BadArgumentException("unknown argument: " + n);
            }
            ResponseData data = null;
            try {
                if (verb.equals("GetRecord")) {
                    if (argCount != 2) {
                        throw new BadArgumentException("two arguments needed, got " + argCount);
                    }
                    data = this.m_responder.getRecord(identifier, metadataPrefix);
                } else if (verb.equals("Identify")) {
                    if (argCount != 0) {
                        throw new BadArgumentException("zero arguments needed, got " + argCount);
                    }
                    data = this.m_responder.identify();
                } else if (verb.equals("ListIdentifiers")) {
                    if (identifier != null) {
                        throw new BadArgumentException("identifier argument is not valid for this verb");
                    }
                    data = this.m_responder.listIdentifiers(from, until, metadataPrefix, set, resumptionToken);
                } else if (verb.equals("ListMetadataFormats")) {
                    if (argCount > 1) {
                        throw new BadArgumentException("one or zero arguments needed, got " + argCount);
                    }
                    data = this.m_responder.listMetadataFormats(identifier);
                } else if (verb.equals("ListRecords")) {
                    if (identifier != null) {
                        throw new BadArgumentException("identifier argument is not valid for this verb");
                    }
                    data = this.m_responder.listRecords(from, until, metadataPrefix, set, resumptionToken);
                } else if (verb.equals("ListSets")) {
                    if (argCount > 1) {
                        throw new BadArgumentException("one or zero arguments needed, got " + argCount);
                    }
                    data = this.m_responder.listSets(resumptionToken);
                } else {
                    throw new BadVerbException("bad verb: " + verb);
                }
                response.setStatus(200);
                response.setContentType("text/xml; charset=UTF-8");
                PrintWriter writer = response.getWriter();
                writer.print(this.getResponseStart(url, verb, identifier, from, until, metadataPrefix, set, resumptionToken, null));
                data.write(response.getWriter());
                writer.println("</OAI-PMH>");
                writer.flush();
                writer.close();
            }
            finally {
                if (data != null) {
                    try {
                        data.release();
                    }
                    catch (ServerException e) {
                        logger.warn((Object)"Could not release response data", (Throwable)e);
                    }
                }
            }
        }
        catch (ProtocolException e) {
            this.sendProtocolException(this.getResponseStart(url, verb, identifier, from, until, metadataPrefix, set, resumptionToken, e), e, response);
        }
        catch (ServerException e) {
            try {
                logger.warn((Object)"OAI Service Error", (Throwable)e);
                response.sendError(500, "OAI Service Error");
            }
            catch (IOException ioe) {
                logger.warn((Object)"Could not send error to client", (Throwable)ioe);
            }
        }
        catch (Throwable th) {
            try {
                logger.warn((Object)"Unexpected Error", th);
                response.sendError(500, "Unexpected error");
            }
            catch (IOException ioe) {
                logger.warn((Object)"Could not send error to client", (Throwable)ioe);
            }
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Finished servicing request from " + request.getRemoteAddr()));
            }
        }
    }

    private String getResponseStart(String url, String verb, String identifier, String from, String until, String metadataPrefix, String set, String resumptionToken, ProtocolException e) {
        boolean doParams = true;
        if (verb == null) {
            doParams = false;
        }
        if (e != null && (e instanceof BadVerbException || e instanceof BadArgumentException)) {
            doParams = false;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(_XMLSTART);
        buf.append(StreamUtil.nowUTCString());
        buf.append("</responseDate>\n");
        buf.append("  <request");
        if (doParams) {
            ProviderServlet.appendAttribute("verb", verb, buf);
            ProviderServlet.appendAttribute("identifier", identifier, buf);
            ProviderServlet.appendAttribute("from", from, buf);
            ProviderServlet.appendAttribute("until", until, buf);
            ProviderServlet.appendAttribute("metadataPrefix", metadataPrefix, buf);
            ProviderServlet.appendAttribute("set", set, buf);
            ProviderServlet.appendAttribute("resumptionToken", resumptionToken, buf);
        }
        buf.append(">" + url + "</request>\n");
        return buf.toString();
    }

    private static void appendAttribute(String name, String value, StringBuffer buf) {
        if (value != null) {
            buf.append(" " + name + "=\"");
            buf.append(StreamUtil.xmlEncode(value));
            buf.append("\"");
        }
    }

    private void sendProtocolException(String responseStart, ProtocolException e, HttpServletResponse response) {
        try {
            response.setStatus(200);
            response.setContentType("text/xml; charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.print(responseStart);
            writer.print("  <error code=\"" + e.getCode() + "\">");
            if (e.getMessage() != null) {
                writer.print(StreamUtil.xmlEncode(e.getMessage()));
            }
            writer.println("</error>");
            writer.println("</OAI-PMH>");
            writer.flush();
            writer.close();
        }
        catch (Throwable th) {
            logger.warn((Object)("Error while sending a protocol exception (" + e.getClass().getName() + ") response"), th);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGet(request, response);
    }

    public void init() throws ServletException {
        try {
            InputStream propStream = ((Object)((Object)this)).getClass().getResourceAsStream("/proai.properties");
            if (propStream == null) {
                throw new IOException("Error loading configuration: /proai.properties not found in classpath");
            }
            Properties props = new Properties();
            props.load(propStream);
            this.init(props);
        }
        catch (Exception e) {
            throw new ServletException("Unable to initialize ProviderServlet", (Throwable)e);
        }
    }

    public void init(Properties props) throws ServerException {
        this.m_responder = new Responder(props);
    }

    public void destroy() {
        try {
            this.m_responder.close();
        }
        catch (Exception e) {
            logger.warn((Object)"Error trying to close Responder", (Throwable)e);
        }
    }
}

