/*
 * Decompiled with CFR 0.152.
 */
package proai.service;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import proai.error.BadResumptionTokenException;
import proai.error.ServerException;
import proai.service.CacheSession;
import proai.service.ListProvider;
import proai.service.ResponseData;
import proai.service.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManager
extends Thread {
    private static final Logger logger = Logger.getLogger((String)SessionManager.class.getName());
    public static final String PROP_BASEDIR = "proai.sessionBaseDir";
    public static final String PROP_SECONDSBETWEENREQUESTS = "proai.secondsBetweenRequests";
    public static final String ERR_RESUMPTION_SYNTAX_SLASH = "bad syntax in resumption token: must contain exactly one slash";
    public static final String ERR_RESUMPTION_SYNTAX_INTEGER = "bad syntax in resumption token: expected an integer after the slash";
    public static final String ERR_RESUMPTION_SESSION = "bad session id or session expired";
    private File m_baseDir;
    private int m_secondsBetweenRequests;
    private Map<String, Session> m_sessions;
    private boolean m_threadNeedsToFinish;
    private boolean m_threadFinished;

    public SessionManager(Properties props) throws ServerException {
        int secondsBetweenRequests;
        String dir = props.getProperty(PROP_BASEDIR);
        if (dir == null) {
            throw new ServerException("Required property missing: proai.sessionBaseDir");
        }
        String sec = props.getProperty(PROP_SECONDSBETWEENREQUESTS);
        if (sec == null) {
            throw new ServerException("Required property missing: proai.secondsBetweenRequests");
        }
        try {
            secondsBetweenRequests = Integer.parseInt(sec);
        }
        catch (Exception e) {
            throw new ServerException("Required property must an integer: proai.secondsBetweenRequests");
        }
        this.init(new File(dir), secondsBetweenRequests);
    }

    public SessionManager(File baseDir, int secondsBetweenRequests) {
        this.init(baseDir, secondsBetweenRequests);
    }

    private void init(File baseDir, int secondsBetweenRequests) throws ServerException {
        this.m_baseDir = baseDir;
        this.m_baseDir.mkdirs();
        File[] dirs = this.m_baseDir.listFiles();
        if (dirs == null) {
            throw new ServerException("Unable to create session directory: " + this.m_baseDir.getPath());
        }
        if (dirs.length > 0) {
            logger.info((Object)("Cleaning up " + dirs.length + " sessions from last run..."));
            try {
                Thread.sleep(4000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            for (int i = 0; i < dirs.length; ++i) {
                if (dirs[i].isDirectory()) {
                    File[] files = dirs[i].listFiles();
                    for (int j = 0; j < files.length; ++j) {
                        files[j].delete();
                    }
                }
                dirs[i].delete();
            }
        }
        this.m_secondsBetweenRequests = secondsBetweenRequests;
        this.m_sessions = new HashMap<String, Session>();
        this.setName("Session-Reaper");
        this.start();
    }

    @Override
    public void run() {
        while (!this.m_threadNeedsToFinish) {
            this.cleanupSessions(false);
            int c = 0;
            while (c < 20 && !this.m_threadNeedsToFinish) {
                ++c;
                try {
                    Thread.sleep(250L);
                }
                catch (Exception exception) {}
            }
        }
        this.m_threadFinished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupSessions(boolean force) {
        ArrayList<String> toCleanKeys = new ArrayList<String>();
        ArrayList<Session> toCleanSessions = new ArrayList<Session>();
        Map<String, Session> map = this.m_sessions;
        synchronized (map) {
            for (String key : this.m_sessions.keySet()) {
                Session sess = this.m_sessions.get(key);
                if (!force && !sess.hasExpired()) continue;
                toCleanKeys.add(key);
                toCleanSessions.add(sess);
            }
            if (toCleanKeys.size() > 0) {
                String dueTo = force ? "shutdown)" : "expired)";
                logger.info((Object)("Cleaning up " + toCleanKeys.size() + " sessions (" + dueTo));
                for (int i = 0; i < toCleanKeys.size(); ++i) {
                    ((Session)toCleanSessions.get(i)).clean();
                    this.m_sessions.remove((String)toCleanKeys.get(i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSession(String key, Session session) {
        if (this.m_threadNeedsToFinish) {
            session.clean();
        } else {
            Map<String, Session> map = this.m_sessions;
            synchronized (map) {
                this.m_sessions.put(key, session);
            }
        }
    }

    public <T> ResponseData list(ListProvider<T> provider) throws ServerException {
        CacheSession<T> session = new CacheSession<T>(this, this.m_baseDir, this.m_secondsBetweenRequests, provider);
        return session.getResponseData(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData getResponseData(String resumptionToken) throws BadResumptionTokenException, ServerException {
        Session session;
        int partNum;
        String[] s = resumptionToken.split("/");
        if (s.length != 2) {
            throw new BadResumptionTokenException(ERR_RESUMPTION_SYNTAX_SLASH);
        }
        try {
            partNum = Integer.parseInt(s[1]);
        }
        catch (Exception e) {
            throw new BadResumptionTokenException(ERR_RESUMPTION_SYNTAX_INTEGER);
        }
        Map<String, Session> map = this.m_sessions;
        synchronized (map) {
            session = this.m_sessions.get(s[0]);
        }
        if (session == null) {
            throw new BadResumptionTokenException(ERR_RESUMPTION_SESSION);
        }
        return session.getResponseData(partNum);
    }

    public void close() {
        this.m_threadNeedsToFinish = true;
        while (!this.m_threadFinished) {
            try {
                Thread.sleep(250L);
            }
            catch (Exception exception) {}
        }
        this.cleanupSessions(true);
    }

    public void finalize() {
        this.close();
    }
}

