/*
 * Decompiled with CFR 0.152.
 */
package org.trippi;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConnectorParameter {
    private String m_name;
    private String m_label;
    private String m_description;
    private boolean m_isOptional;
    private List m_options;
    private Map m_parameterMap;

    public ConnectorParameter(String name, String label, String description, boolean isOptional, List options, Map parameterMap) {
        this.m_name = name;
        this.m_label = label;
        this.m_description = description;
        this.m_isOptional = isOptional;
        this.m_options = options;
        this.m_parameterMap = parameterMap;
    }

    public String getName() {
        return this.m_name;
    }

    public String getLabel() {
        return this.m_label;
    }

    public String getDescription() {
        return this.m_description;
    }

    public boolean isOptional() {
        return this.m_isOptional;
    }

    public List getOptions() {
        return this.m_options;
    }

    public List getParameters(String value) {
        return (List)this.m_parameterMap.get(value);
    }

    public String toString(int i) {
        StringBuffer out = new StringBuffer();
        out.append(ConnectorParameter.indent(i) + "Parameter      : " + this.getName() + "\n");
        out.append(ConnectorParameter.indent(i) + " label         : " + this.getLabel() + "\n");
        out.append(ConnectorParameter.indent(i) + " description   : " + this.getDescription() + "\n");
        out.append(ConnectorParameter.indent(i) + " is optional   : " + this.isOptional() + "\n");
        Iterator iter = this.getOptions().iterator();
        while (iter.hasNext()) {
            String val = (String)iter.next();
            out.append(ConnectorParameter.indent(i) + " OPTION        : " + val + "\n");
            List p = this.getParameters(val);
            if (p == null) continue;
            Iterator pIter = p.iterator();
            while (pIter.hasNext()) {
                out.append(((ConnectorParameter)pIter.next()).toString(i + 4));
            }
        }
        return out.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    private static String indent(int by) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < by; ++i) {
            out.append(' ');
        }
        return out.toString();
    }
}

