/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.impl.base;

import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.trippi.TripleIterator;
import org.trippi.TriplePattern;
import org.trippi.TriplestoreReader;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;
import org.trippi.impl.base.AliasManager;
import org.trippi.impl.base.DistinctTripleIterator;
import org.trippi.impl.base.DistinctTupleIterator;
import org.trippi.impl.base.LimitedTripleIterator;
import org.trippi.impl.base.LimitedTupleIterator;
import org.trippi.impl.base.SynchronizedTriplestoreSession;
import org.trippi.impl.base.TupleBasedTripleIterator;

public class SynchronizedTriplestoreReader
implements TriplestoreReader {
    private static final Logger logger = Logger.getLogger((String)SynchronizedTriplestoreReader.class.getName());
    private SynchronizedTriplestoreSession m_session;
    private AliasManager m_aliasManager;

    public SynchronizedTriplestoreReader(SynchronizedTriplestoreSession session, AliasManager aliasManager) {
        this.m_session = session;
        this.m_aliasManager = aliasManager;
    }

    public Map getAliasMap() {
        return this.m_aliasManager.getAliasMap();
    }

    public void setAliasMap(Map aliasMap) {
        this.m_aliasManager.setAliasMap(aliasMap);
    }

    public String[] listTupleLanguages() {
        return this.m_session.listTupleLanguages();
    }

    public String[] listTripleLanguages() {
        return this.m_session.listTripleLanguages();
    }

    public int countTuples(String queryLang, String tupleQuery, int limit, boolean distinct) throws TrippiException {
        return this.findTuples(queryLang, tupleQuery, limit, distinct).count();
    }

    public TupleIterator findTuples(String queryLang, String tupleQuery, int limit, boolean distinct) throws TrippiException {
        TupleIterator iter = null;
        iter = this.m_session.query(tupleQuery, queryLang);
        if (distinct) {
            iter = new DistinctTupleIterator(iter);
        }
        if (limit > 0) {
            iter = new LimitedTupleIterator(iter, limit);
        }
        return iter;
    }

    private String doAliasReplacements(String q) {
        String out = q;
        Map m = this.m_aliasManager.getAliasMap();
        Iterator iter = m.keySet().iterator();
        while (iter.hasNext()) {
            String alias = (String)iter.next();
            String fullForm = (String)m.get(alias);
            out = out.replaceAll("<" + alias + ":", "<" + fullForm).replaceAll("\\^\\^" + alias + ":(\\S+)", "^^<" + fullForm + "$1>");
        }
        if (!q.equals(out)) {
            logger.info((Object)("Substituted aliases, query is now: " + out));
        }
        return out;
    }

    public int countTriples(String queryLang, String tripleQuery, int limit, boolean distinct) throws TrippiException {
        return this.findTriples(queryLang, tripleQuery, limit, distinct).count();
    }

    public TripleIterator findTriples(String queryLang, String tripleQuery, int limit, boolean distinct) throws TrippiException {
        if (queryLang.equals("spo")) {
            TriplePattern[] patterns = TriplePattern.parse(this.doAliasReplacements(tripleQuery));
            if (patterns.length == 1) {
                TriplePattern p = patterns[0];
                SubjectNode subject = null;
                PredicateNode predicate = null;
                ObjectNode object = null;
                if (p.getSubject() instanceof SubjectNode) {
                    subject = (SubjectNode)p.getSubject();
                }
                if (p.getPredicate() instanceof PredicateNode) {
                    predicate = (PredicateNode)p.getPredicate();
                }
                if (p.getObject() instanceof ObjectNode) {
                    object = (ObjectNode)p.getObject();
                }
                return this.findTriples(subject, predicate, object, limit);
            }
            throw new TrippiException("Only one triple pattern may be specified.");
        }
        TripleIterator iter = null;
        iter = this.m_session.findTriples(queryLang, tripleQuery);
        if (distinct) {
            iter = new DistinctTripleIterator(iter);
        }
        if (limit > 0) {
            iter = new LimitedTripleIterator(iter, limit);
        }
        return iter;
    }

    public int countTriples(SubjectNode subject, PredicateNode predicate, ObjectNode object, int limit) throws TrippiException {
        return this.findTriples(subject, predicate, object, limit).count();
    }

    public TripleIterator findTriples(SubjectNode subject, PredicateNode predicate, ObjectNode object, int limit) throws TrippiException {
        TripleIterator iter = null;
        iter = this.m_session.findTriples(subject, predicate, object);
        if (limit > 0) {
            iter = new LimitedTripleIterator(iter, limit);
        }
        return iter;
    }

    public int countTriples(String queryLang, String tupleQuery, String tripleTemplate, int limit, boolean distinct) throws TrippiException {
        return this.findTriples(queryLang, tupleQuery, tripleTemplate, limit, distinct).count();
    }

    public TripleIterator findTriples(String queryLang, String tupleQuery, String tripleTemplate, int limit, boolean distinct) throws TrippiException {
        TriplePattern[] patterns = TriplePattern.parse(tripleTemplate);
        TripleIterator iter = new TupleBasedTripleIterator(this.findTuples(queryLang, tupleQuery, -1, distinct), patterns);
        if (distinct) {
            iter = new DistinctTripleIterator(iter);
        }
        if (limit > 0) {
            iter = new LimitedTripleIterator(iter, limit);
        }
        return iter;
    }

    public void close() throws TrippiException {
        logger.info((Object)"SynchronizedTripleStoreReader closing TripleStoreSession...");
        this.m_session.close();
    }

    public void finalize() throws TrippiException {
        this.close();
    }
}

